const axios = require('axios');
const config = require('../config/gemini');

const fs = require('fs');
const path = require('path');

function logErrorToFile(error) {
  const logPath = path.join(__dirname, '../logs/error.log');
  const timestamp = new Date().toISOString();
  const mensaje = `[${timestamp}] ${error}\n`;

  fs.appendFile(logPath, mensaje, err => {
    if (err) console.error('Error al escribir log de Gemini:', err);
  });
}

const GeminiService = {
  async responderGemini(mensajeUsuario) {
    const instruccionesIniciales = "Eres Maru, perteneces a una empresa vendedora de zapatos para gatos, a los clientes diles michilover";

    for (const key of config.keys) {
      try {
        const response = await axios.post(
          `https://generativelanguage.googleapis.com/v1beta/models/${config.model}:generateContent`,
          {
            contents: [
              { role: 'user', parts: [{ text: instruccionesIniciales }] },
              { role: 'user', parts: [{ text: mensajeUsuario }] }
            ]
          },
          {
            params: { key },
            timeout: 2500
          }
        );

        const texto = response.data.candidates?.[0]?.content?.parts?.[0]?.text;

        if (texto && texto.trim().length > 0) {
          return texto;
        } else {
          console.warn(`Clave ${key} respondió sin texto útil`);
        }

      } catch (err) {
        const detalle = err.response?.data || err.message;
        const errorTexto = `Error consultando Gemini con clave ${key}: ${JSON.stringify(detalle)}`;
        console.warn(errorTexto);
        logErrorToFile(errorTexto);
      }
    }

    throw new Error('Todas las claves de Gemini fallaron o no devolvieron respuesta');
  }
};

module.exports = GeminiService;
