class Negocio {
    constructor(data = {}) {
      this.id_cliente = data.id_cliente || null;
      this.nombre_negocio = data.nombre_negocio || 'Zapateria Juanito';
      this.nombre_propietario = data.nombre_propietario || 'No definido';
      this.telefono_contacto = data.telefono_contacto || null;
      this.email_contacto = data.email_contacto || null;
      this.rubro_principal = data.rubro_principal || 'General';
      this.tipo_plan = data.tipo_plan || 'Básico';
      this.estado_cliente = data.estado_cliente || 'Inactivo';
      this.nombre_schema = data.nombre_schema || 'public';
      this.fecha_registro = data.fecha_registro || new Date();
      this.tokens_acumulados_mes = data.tokens_acumulados_mes || 0;
    }
  
    // ✅ Devuelve true si el negocio está activo
    esActivo() {
      return this.estado_cliente === 'Activo';
    }
  
    // ✅ Devuelve true si tiene un plan "Premium"
    esPremium() {
      return this.tipo_plan?.toLowerCase() === 'premium';
    }
  
    // ✅ Decide el modelo de IA preferido según plan
    obtenerModeloPreferido() {
      if (!this.esActivo()) return null;
  
      if (this.esPremium()) return 'groq'; // Groq para planes Premium
      return 'openai'; // Básico o inactivo
    }
  
    // ✅ Devuelve una etiqueta resumida
    resumen() {
      return `${this.nombre_negocio} (${this.tipo_plan})`;
    }
  
    // ✅ Devuelve true si pertenece a un rubro específico
    esDelRubro(rubro) {
      return this.rubro_principal?.toLowerCase() === rubro.toLowerCase();
    }
  }
  
  module.exports = Negocio;
  